/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.ddl;

import org.h14199.command.ddl.DefineCommand;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.index.Index;
import org.h14199.message.DbException;
import org.h14199.schema.Schema;

public class AlterIndexRename
extends DefineCommand {
    private boolean ifExists;
    private Schema oldSchema;
    private String oldIndexName;
    private String newIndexName;

    public AlterIndexRename(Session session) {
        super(session);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setOldSchema(Schema schema) {
        this.oldSchema = schema;
    }

    public void setOldName(String string) {
        this.oldIndexName = string;
    }

    public void setNewName(String string) {
        this.newIndexName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Index index = this.oldSchema.findIndex(this.session, this.oldIndexName);
        if (index == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.newIndexName);
            }
            return 0;
        }
        if (this.oldSchema.findIndex(this.session, this.newIndexName) != null || this.newIndexName.equals(this.oldIndexName)) {
            throw DbException.get(42111, this.newIndexName);
        }
        this.session.getUser().checkRight(index.getTable(), 15);
        database.renameSchemaObject(this.session, index, this.newIndexName);
        return 0;
    }

    @Override
    public int getType() {
        return 1;
    }
}

